//=============================================================================
// MarkusGrayMaleCarcass.
//=============================================================================
class MarkusGrayMaleCarcass extends MarkistanCarcass;

// ----------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------

function PostPostBeginPlay()
{
	local MarkusGrayMale player;

	Super.PostPostBeginPlay();

	foreach AllActors(class'MarkusGrayMale', player)
		break;

	SetSkin(player);
}

// ----------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------
function SetSkin(MarkusGrayMale player)
{
	if (player != None)
	{
		switch(player.PlayerSkin)
		{
			case 0:		MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2'; break;
			case 1:		MultiSkins[0] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[1] = Texture'Markistan.Skins.TylerTex2';
			MultiSkins[3] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[4] = Texture'Markistan.Skins.TylerTex1';
			MultiSkins[5] = Texture'Markistan.Skins.TylerTex2'; break;
			case 2:		MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2'; break;
			case 3:		MultiSkins[0] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[1] = Texture'Markistan.Skins.TylerTex2';
			MultiSkins[3] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[4] = Texture'Markistan.Skins.TylerTex1';
			MultiSkins[5] = Texture'Markistan.Skins.TylerTex2'; break;
			case 4:		MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2'; break;
		}
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     Mesh2=LodMesh'DeusExCharacters.GM_Trench_CarcassB'
     Mesh3=LodMesh'DeusExCharacters.GM_Trench_CarcassC'
     Mesh=LodMesh'DeusExCharacters.GM_Trench_Carcass'
     MultiSkins(0)=Texture'Markistan.Skins.MarkusTex0'
     MultiSkins(1)=Texture'Markistan.Skins.MarkusTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex8'
     MultiSkins(3)=Texture'Markistan.Skins.MarkusTex0'
     MultiSkins(4)=Texture'Markistan.Skins.MarkusTex1'
     MultiSkins(5)=Texture'Markistan.Skins.MarkusTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=40.000000
}
